<?php

namespace Netzperfekt\SaasProptrend\Enums;

use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasLabel;

enum SourceType: int implements HasLabel, HasIcon
{
    case Default        =  0;

    public function getLabel(): ?string
    {
        return match ($this) {
            self::Default        => __('proptrend-enum-source-default'),
        };
    }

    public function getIcon(): ?string
    {
        return match ($this) {
            self::Default        => 'fas-info',
        };
    }
}