<?php

namespace Netzperfekt\SaasProptrend\Filament\Resources\PropResource\RelationManagers;

use Awcodes\TableRepeater\Components\TableRepeater;
use Awcodes\TableRepeater\Header;
use Filament\Facades\Filament;
use Filament\Forms;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Support\Colors\Color;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Support\Str;
use Netzperfekt\SaasProptrend\Enums\PropHistoryType;

class HistoryRelationManager extends RelationManager
{
    protected static string $relationship = 'history';

    public function form(Form $form): Form
    {
        return $form
            ->columns(3)
            ->schema([
                Forms\Components\Select::make('type')
                    ->label(__('proptrend-type'))
                    ->options(PropHistoryType::class)
                    ->columnSpan(1)
                    ->required(),

                Forms\Components\Textarea::make('comments')
                    ->columnSpanFull()
                    ->rows(5)
                    ->label(__('proptrend-comments')),

                TableRepeater::make('fields')
                    ->label(__('proptrend-fields'))
                    ->hidden(fn($get) => empty($get('fields')))
                    ->addable(false)
                    ->deletable(false)
                    ->reorderable(false)
                    ->streamlined()
                    ->columnSpanFull()

                    ->headers([
                        Header::make('label')
                            ->label(__('proptrend-field-label'))
                            ->width('250px'),
                        Header::make('path')
                            ->label(__('proptrend-field-path'))
                            ->width('250px'),
                        Header::make('value')
                            ->label(__('proptrend-field-value')),
                    ])
                    ->schema([
                        TextInput::make('label')->disabled()->dehydrated(),
                        TextInput::make('path')->disabled()->dehydrated(),
                        TextInput::make('value')
                    ]),

                Forms\Components\FileUpload::make('media')
                    ->label(__('proptrend-media'))
                    ->columnSpanFull()
                    ->panelLayout('grid')
                    ->disk(config('saas-proptrend.attachments_disk'))
                    ->directory(fn($record) => getMediaDirectory($record->prop_id))
                    ->maxSize(config('saas-proptrend.attachments_max_size'))
                    ->multiple()
                    ->reorderable()
                    ->visibility('private')
                    ->downloadable(true)
                    ->openable(true)
                    ->moveFiles()
            ]);

        // TODO fields aus erstem history-eintrag mit type "update" prominent beim parent/prop anzeigen!
        // TODO screenshot anzeigen (popup), falls vorhanden
        // TODO html anzeigen (popup), falls vorhanden
        // TODO fields anzeigen (popup), falls type=update und vorhanden
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('type')
            ->columns([
                Tables\Columns\TextColumn::make('created_at')
                    ->date('d.m.Y H:i')
                    ->label(__('proptrend-date')),

                Tables\Columns\TextColumn::make('type')
                    ->label(__('proptrend-type'))
                    ->badge(),

                Tables\Columns\TextColumn::make('comments')
                    ->label(__('proptrend-comments'))
                    ->limit(80),

                Tables\Columns\TextColumn::make('media')
                    ->label(__('proptrend-media'))
                    ->badge()
                    ->color(Color::Orange)
                    ->state(fn ($record): string => $record->media ? count($record->media) : '')
            ])

            ->defaultSort('created_at', 'DESC')

            ->filters([
                //
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make(),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }
}
