<?php

namespace Netzperfekt\SaasProptrend\Listeners;

use Filament\Forms\Components\Grid;
use Filament\Forms\Components\KeyValue;
use Filament\Forms\Components\TextInput;
use Filament\Support\Enums\MaxWidth;

class GetSettingsFields
{
    public function handle($event): array
    {
        return [
            'label'  => config('app.name'),
            'sort'   => 0,
            'fields' => [
                Grid::make(2)
                ->schema([
                    TextInput::make('notary_fees')
                        ->label(__('proptrend-settings-notary-fees'))
                        ->suffix('%')
                        ->numeric()
                        ->minValue(0)
                        ->maxValue(10)
                        ->default(1.5),

                    TextInput::make('land_register_fees')
                        ->label(__('proptrend-settings-land-register-fees'))
                        ->suffix('%')
                        ->numeric()
                        ->minValue(0)
                        ->maxValue(10)
                        ->default(0.5),

                    TextInput::make('update_frequency')
                        ->label(__('proptrend-settings-update-frequency'))
                        ->suffix(__('proptrend-days'))
                        ->numeric()
                        ->minValue(0) // eigentlich 1 - 0 für testzwecke (sofort aktualisieren)
                        ->maxValue(90)
                        ->default(1),
                ]),

                KeyValue::make('state_taxes')
                    ->label(__('proptrend-settings-state-taxes'))
                    ->keyLabel(__('proptrend-settings-state'))
                    ->valueLabel(__('proptrend-tax'))
                    ->addable(false)
                    ->deletable(false)
                    ->editableKeys(false)
                    ->maxWidth(MaxWidth::ExtraSmall)
                    ->default([
                        'BW'  => '5.0',
                        'BY'  => '3.5',
                        'BE'  => '6.0',
                        'BB'  => '6.5',
                        'HB'  => '5.0',
                        'HH'  => '5.5',
                        'HE'  => '6.0',
                        'MV'  => '6.0',
                        'NDS' => '5.0',
                        'NRW' => '6.5',
                        'RP'  => '5.0',
                        'SL'  => '6.5',
                        'SN'  => '5.5',
                        'SA'  => '5.0',
                        'SH'  => '6.5',
                        'TH'  => '6.5'
                    ])
            ]

        ];
    }
}
