<?php

namespace Netzperfekt\SaasProptrend\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Netzperfekt\SaasProptrend\Enums\PropStatus;
use Netzperfekt\SaasProptrend\Filament\Resources\PropResource\PropResource;
use Netzperfekt\SaasProptrend\Models\ProptrendProp;

class PropertyUpdated extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public function __construct(public readonly ProptrendProp $property)
    {
        //
    }

    public function envelope(): Envelope
    {
        if($this->property->status == PropStatus::Removed)
        {
            $subject = __('proptrend-mail-property-removed');
        }
        else
        {
            $subject = __('proptrend-mail-property-updated');
        }

        return new Envelope(
            subject: $subject . ': ' . $this->property->place,
        );
    }

    public function content(): Content
    {
        return new Content(
            markdown: 'saas-proptrend::mail.property-updated',
            with: [
                'propertyUrlProptrend'
                    => PropResource::getUrl('edit', ['tenant' => $this->property->team_id, 'record' => $this->property]),
                'propertyUrlOriginal'
                    => $this->property->url,
                'propertySource'
                    => $this->property->source->title,
                'changedFields'
                    => $this->property->getChangedFields(true)
            ]
        );
    }

    public function attachments(): array
    {
        return [];
    }
}
