<?php

namespace Netzperfekt\SaasProptrend\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Netzperfekt\SaasBase\Models\Team;
use Netzperfekt\SaasBase\Traits\HasDefaultScopes;
use Netzperfekt\SaasBase\Traits\HasGlobalModelObserver;
use Netzperfekt\SaasProptrend\Enums\ProjectStatus;
use Netzperfekt\SaasProptrend\Enums\ProjectType;

class ProptrendProjects extends Model
{
    use SoftDeletes;
    use HasGlobalModelObserver;
    use HasDefaultScopes;

    protected $table = 'proptrend_projects';

    protected $fillable = [
        'id', 'deleted_at', 'created_at', 'updated_at',
        'team_id',

        'title',
        'type',
        'status',
        'fields'
    ];

    protected $casts = [
        'fields' => 'array',
        'type'   => ProjectType::class,
        'status' => ProjectStatus::class
    ];

    public function team(): BelongsTo
    {
        return $this->belongsTo(Team::class);
    }

    public function sources(): HasMany
    {
        return $this->hasMany(ProptrendSource::class, 'project_id', 'id');
    }

    public function props(): HasMany
    {
        return $this->hasMany(ProptrendProp::class, 'project_id', 'id');
    }
}
