<?php

namespace Netzperfekt\SaasProptrend\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Netzperfekt\SaasBase\Models\Team;
use Netzperfekt\SaasBase\Traits\HasDefaultScopes;
use Netzperfekt\SaasBase\Traits\HasGlobalModelObserver;
use Netzperfekt\SaasProptrend\Enums\PropHistoryType;

class ProptrendPropsHistory extends Model
{
    use SoftDeletes;
    use HasGlobalModelObserver;
    use HasDefaultScopes;

    protected $table = 'proptrend_props_history';

    protected $fillable = [
        'id', 'deleted_at', 'created_at', 'updated_at',
        'prop_id',

        'type',
        'html',
        'fields',
        'media',
        'comments'
    ];

    protected $casts = [
        'type'   => PropHistoryType::class,
        'fields' => 'array',
        'media'  => 'array'
    ];

    public function team(): BelongsTo
    {
        return $this->belongsTo(Team::class);
    }

    public function prop(): BelongsTo
    {
        return $this->belongsTo(ProptrendProp::class);
    }
}
