<?php

namespace Netzperfekt\SaasProptrend\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Netzperfekt\SaasBase\Models\Team;
use Netzperfekt\SaasBase\Traits\HasDefaultScopes;
use Netzperfekt\SaasBase\Traits\HasGlobalModelObserver;

class ProptrendSource extends Model
{
    use SoftDeletes;
    use HasGlobalModelObserver;
    use HasDefaultScopes;

    protected $table = 'proptrend_sources';

    protected $fillable = [
        'id', 'deleted_at', 'created_at', 'updated_at',
        'team_id',
        'project_id',

        'url',
        'title',
        'field_mappings'
    ];

    protected $casts = [
        'field_mappings' => 'array'
    ];

    public function team(): BelongsTo
    {
        return $this->belongsTo(Team::class);
    }

    public function project(): BelongsTo
    {
        return $this->belongsTo(ProptrendProjects::class, 'project_id', 'id');
    }
}
