<?php

namespace Netzperfekt\SaasProptrend;

use Filament\Contracts\Plugin;
use Filament\Panel;
use Netzperfekt\SaasProptrend\Filament\Pages\PropEntry;
use Netzperfekt\SaasProptrend\Filament\Resources\ProjectResource\ProjectResource;
use Netzperfekt\SaasProptrend\Filament\Resources\PropResource\PropResource;
use Netzperfekt\SaasProptrend\Filament\Resources\SourceResource\SourceResource;

class SaasProptrend implements Plugin
{
    public final const PACKAGE_NAME = 'saas-proptrend';

    protected bool $isEnabled = false;
    protected bool $forTenants = false;
    protected string $forTenantsPackage = '';

    public static function make(): SaasProptrend
    {
        return new SaasProptrend();
    }

    public function getId(): string
    {
        return self::PACKAGE_NAME;
    }

    public function register(Panel $panel): void
    {
        if($this->getIsEnabled())
        {
            $activePages = [];
            $activeResources = [];

            if($this->getForTenants())
            {
                $activePages = [
                    PropEntry::class
                ];

                $activeResources = [
                    PropResource::class,
                    ProjectResource::class,
                    SourceResource::class,
                ];
            }
            else
            {
                $activePages = [
                ];

                $activeResources = [
                ];
            }

            $panel->pages($activePages);
            $panel->resources($activeResources);
        }
    }

    public function boot(Panel $panel): void
    {
    }

    public function getIsEnabled(): bool
    {
        return $this->isEnabled;
    }

    public function isEnabled(bool $value): static
    {
        $this->isEnabled = $value;

        return $this;
    }

    public function getForTenants(): bool
    {
        return $this->forTenants;
    }

    public function getForTenantsPackage(): string
    {
        return $this->forTenantsPackage;
    }

    public function enableForTenantsInPackage(string $packageName): static
    {
        $this->forTenants = true;
        $this->forTenantsPackage = $packageName;

        return $this;
    }

    public static function get(): static
    {
        return filament(app(static::class)->getId());
    }
}
