<?php

namespace Netzperfekt\SaasProptrend;

use Filament\Support\Assets\Css;
use Filament\Support\Assets\Js;
use Filament\Support\Colors\Color;
use Filament\Support\Facades\FilamentAsset;
use Filament\Tables\Columns\Column;
use Netzperfekt\SaasProptrend\Commands\UpdatePropertiesCommand;
use Spatie\LaravelPackageTools\Commands\InstallCommand;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class SaasProptrendServiceProvider extends PackageServiceProvider
{
    public function packageRegistered()
    {
        $this->app->register(EventServiceProvider::class);
    }

    public function packageBooted()
    {
        $this->addAssets();
        $this->addMacros();
        $this->addDocs();
    }

    public function configurePackage(Package $package): void
    {
        $package
            ->name(SaasProptrend::PACKAGE_NAME)
            ->hasRoute('web')
            ->hasViews()
            ->hasConfigFile()
            ->hasTranslations()

            ->hasMigrations([
                'create_projects_table',
                'create_sources_table',
                'create_props_table',
                'create_props_history_table'
            ])

            ->hasCommands(
                UpdatePropertiesCommand::class
            )

            ->hasInstallCommand(function(InstallCommand $command)
            {
                $command
                    ->publishAssets()
                    ->publishMigrations()
                    ->publishConfigFile()
                    ->askToRunMigrations();
            });
    }

    private function addAssets()
    {
        FilamentAsset::register([
            Js::make('saas-proptrend-js', __DIR__ . '/../resources/dist/saas-proptrend.js'),

            Css::make('saas-proptrend-css', __DIR__ . '/../resources/dist/saas-proptrend.css'),
            Css::make('saas-proptrend-css-frontend', __DIR__ . '/../resources/dist/saas-proptrend-frontend.css')
        ], 'netzperfekt/saas-proptrend');
    }

    private function addDocs()
    {
        $this->publishes([
            $this->package->basePath('/../docs') => base_path("/docs"),
        ], "{$this->package->shortName()}-docs");

    }

    private function addMacros()
    {
        Column::macro('tags', function()
        {
            return $this
                ->label(__('proptrend-tags'))
                ->width('250px')
                ->searchable()
                ->badge()
                ->color(Color::Orange);
        });

        Column::macro('openUrl', function(bool $openInNewTab = true)
        {
            return $this
                ->label('')
                ->icon(fn (?string $state): string => $state ? 'heroicon-o-link' : '')
                ->tooltip(fn ($state) => $state)
                ->url(fn (?string $state): string => $state ?? '', $openInNewTab)
                ->color('info');
        });
    }
}
