<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Netzperfekt\SaasBase\Models\Team;
use Netzperfekt\SaasDeadman\Models\Infofolder;

class InfofolderFactory extends Factory
{
    protected $model = Infofolder::class;

    public function definition(): array
    {
        $title = $this->faker->name();

        return [
            'title' => $title,
            'slug' => Str::slug($title),

            'team_id' => Team::factory()
        ];
    }

    public function withTeam(Team $team): Factory
    {
        return $this->state(function (array $attributes) use ($team) {
            return [
                'team_id' => $team->id
            ];
        });
    }
}
