<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Netzperfekt\SaasBase\Models\Team;
use Netzperfekt\SaasTerve\Enums\ObjectType;
use Netzperfekt\SaasTerve\Models\Object;

class ObjectFactory extends Factory
{
    protected $model = Object::class;

    public function definition(): array
    {
        $title = $this->faker->name();

        return [
            'type' => $this->faker->randomElement(ObjectType::cases())->value,
            'title' => $title,
            'slug' => Str::slug($title),
            'street' => $this->faker->streetName(),
            'zip' => $this->faker->postcode(),
            'city' => $this->faker->city(),
            'country' => $this->faker->country(),
            'lat' => $this->faker->latitude(),
            'lng' => $this->faker->longitude(),
            'email' => $this->faker->unique()->safeEmail(),
            'phone' => $this->faker->phoneNumber(),
            'homepage' => $this->faker->url(),
            'is_public' => $this->faker->boolean(),

            'team_id' => Team::factory()
        ];
    }

    public function withTeam(Team $team): Factory
    {
        return $this->state(function (array $attributes) use ($team) {
            return [
                'team_id' => $team->id
            ];
        });
    }
}
