<?php

use Illuminate\Support\Facades\Route;
use Netzperfekt\SaasTerve\Controllers\ProxyController;
use Netzperfekt\SaasTerve\Controllers\SwitchController;
use ParagonIE\Halite\KeyFactory;
use ParagonIE\HiddenString\HiddenString;
use ParagonIE\Halite\Symmetric\Crypto as Symmetric;

Route::get('/switch-confirm/{switchid}', [SwitchController::class, 'confirmSwitch'])->name('switch.confirm');

Route::middleware(['web'])->group(function ()
{
    Route::get(
        '/proxy/download/{disk}/{filename}',
        [ProxyController::class, 'downloadAttachment']
    )->name('proxy.download');


    // TODO raus
    Route::Get('test1', function()
    {
        dd(\Illuminate\Support\Facades\Storage::disk('do_attachments')->allFiles());
    });

    // TODO raus
    Route::get('test', function()
    {
        $encKey = KeyFactory::generateEncryptionKey();

        $userId = 42;
        $keyPath = storage_path('keys/user' . $userId . '.key');

        if(! file_exists(dirname($keyPath))) {
            mkdir(dirname($keyPath));
        }

        KeyFactory::save($encKey, $keyPath);

        // ---

        $encryptionKey = KeyFactory::loadEncryptionKey($keyPath);

        $message = new HiddenString('This is a confidential message for your eyes only.');
        $ciphertext = Symmetric::encrypt($message, $encryptionKey);

        $decrypted = Symmetric::decrypt($ciphertext, $encryptionKey);

        dd($decrypted->getString());
    });
});
