<?php

namespace Netzperfekt\SaasTerve\Enums;

use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasLabel;

enum ObjectType: int implements HasLabel, HasIcon
{
    case VacationHome        = 0;
    case VacationAppartement = 1;
    case Yacht               = 10;
    case MobileHome          = 20;
    case Other               = 99;

    public function getLabel(): ?string
    {
        return match ($this) {
            self::VacationHome        => __('terve-enum-object-vacationhome'),
            self::VacationAppartement => __('terve-enum-object-vacationappartement'),
            self::Yacht               => __('terve-enum-object-yacht'),
            self::MobileHome          => __('terve-enum-object-mobilehome'),
            self::Other               => __('terve-enum-object-other'),
        };
    }

    public function getIcon(): ?string
    {
        return match ($this) {
            self::VacationHome        => 'fas-house',
            self::VacationAppartement => 'fas-building',
            self::Yacht               => 'fas-sailboat',
            self::MobileHome          => 'fas-van-shuttle',
            self::Other               => 'fas-star',
        };
    }
}
