<?php

namespace Netzperfekt\SaasDeadman\Enums;

use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasLabel;

enum PoiType: int implements HasLabel, HasIcon
{
    case Gastronomy        =  0;
    case Sight             = 10;
    case Beach             = 11;
    case Store             = 20;
    case Medical           = 80;
    case Other             = 99;

    public function getLabel(): ?string
    {
        return match ($this) {
            self::Gastronomy => __('terve-enum-poi-gastronomy'),
            self::Sight      => __('terve-enum-poi-sight'),
            self::Beach      => __('terve-enum-poi-beach'),
            self::Store      => __('terve-enum-poi-store'),
            self::Medical    => __('terve-enum-poi-medical'),
            self::Other      => __('terve-enum-poi-other'),
        };
    }

    public function getIcon(): ?string
    {
        return match ($this) {
            self::Gastronomy => 'fas-utensils',
            self::Sight      => 'fas-map-location-dot',
            self::Beach      => 'fas-van-umbrella-beach',
            self::Store      => 'fas-store',
            self::Medical    => 'fas-briefcase-medical',
            self::Other      => 'fas-star',
        };
    }
}
