<?php

namespace Netzperfekt\SaasTerve\Filament\Resources;

use Filament\Facades\Filament;
use Filament\Forms\Components\Builder;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Grid;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;

class ContentBlocks
{
    public const TYPE_MESSAGE_BLOCK    = 'message-block';
    public const TYPE_LINK_BLOCK       = 'link-block';
    public const TYPE_ATTACHMENT_BLOCK = 'attachment-block';

    public static function getContentBlocks()
    {
        return [
            self::getContentBlockMessage(),
            self::getContentBlockLink(),
            self::getAttachmentBlockLink()
        ];
    }

    private static function getContentBlockMessage()
    {
        return Builder\Block::make(self::TYPE_MESSAGE_BLOCK)
            ->label(__('terve-content-message-block'))
            ->maxItems(1)
            ->schema([
                Textarea::make('message')
                    ->label(__('terve-content-message'))
                    ->rows(5)
                    ->required()
            ]);
    }

    private static function getContentBlockLink()
    {
        return Builder\Block::make(self::TYPE_LINK_BLOCK)
            ->label(__('terve-content-link-block'))
            ->schema([
                Grid::make(4)
                    ->schema([
                        TextInput::make('link')
                            ->label(__('terve-content-link'))
                            ->columnSpan(2)
                            ->url()
                            ->required(),

                        TextInput::make('username')
                            ->label(__('terve-content-username'))
                            ->helperText(__('deadmen-content-optional')),

                        TextInput::make('password')
                            ->label(__('terve-content-password'))
                            ->helperText(__('deadmen-content-optional')),
                    ])
            ]);
    }

    private static function getAttachmentBlockLink()
    {
        return Builder\Block::make(self::TYPE_ATTACHMENT_BLOCK)
            ->label(__('terve-content-attachment-block'))
            ->schema([
                Grid::make(5)
                    ->schema([
                    ])
            ]);
    }
}
