<?php

namespace Netzperfekt\SaasDeadman\Models;

use Database\Factories\PoiFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Netzperfekt\SaasBase\Models\Team;
use Netzperfekt\SaasBase\Traits\HasDefaultScopes;
use Netzperfekt\SaasBase\Traits\HasGlobalModelObserver;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Netzperfekt\SaasTerve\Models\TerveObject;

class Infofolder extends Model
{
    use HasFactory;
    use SoftDeletes;
    use HasGlobalModelObserver;
    use HasDefaultScopes;

    protected $table = 'terve_poi';

    protected $fillable = [
        'id', 'deleted_at', 'created_at', 'updated_at', 'team_id',
        'object_id',
        'title',
        'slug',
        'image',
        'contents'
    ];

    protected $casts = [
        'contents' => 'array'
    ];

    public function team(): BelongsTo
    {
        return $this->belongsTo(Team::class);
    }

    public function object(): BelongsTo
    {
        return $this->belongsTo(TerveObject::class, 'object_id', 'id');
    }

    protected static function newFactory(): Factory
    {
        return PoiFactory::new();
    }
}
