<?php

namespace Netzperfekt\SaasDeadman\Models;

use Database\Factories\PoiFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Netzperfekt\SaasBase\Models\Team;
use Netzperfekt\SaasBase\Traits\HasDefaultScopes;
use Netzperfekt\SaasBase\Traits\HasGlobalModelObserver;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Netzperfekt\SaasDeadman\Enums\PoiType;

class Poi extends Model
{
    use HasFactory;
    use SoftDeletes;
    use HasGlobalModelObserver;
    use HasDefaultScopes;

    protected $table = 'terve_poi';

    protected $fillable = [
        'id', 'deleted_at', 'created_at', 'updated_at', 'team_id',
        'type',
        'title',
        'slug',
        'street',
        'zip',
        'city',
        'country',
        'lat',
        'lng',
        'description_short',
        'description_long',
        'email',
        'phone',
        'homepage',
        'image'
    ];

    protected $casts = [
        'type' => PoiType::class
    ];

    public function team(): BelongsTo
    {
        return $this->belongsTo(Team::class);
    }

    public function getLocationAttribute(): array
    {
        return [
            'lat' => (float)$this->lat,
            'lng' => (float)$this->lon,
        ];
    }

    public function setLocationAttribute(?array $location): void
    {
        if (is_array($location))
        {
            $this->attributes['lat'] = $location['lat'];
            $this->attributes['lon'] = $location['lng'];
            unset($this->attributes['location']);
        }
    }

    public static function getLatLngAttributes(): array
    {
        return [
            'lat' => 'lat',
            'lng' => 'lon',
        ];
    }

    public static function getComputedLocation(): string
    {
        return 'location';
    }

    protected static function newFactory(): Factory
    {
        return PoiFactory::new();
    }
}
