<?php

namespace Netzperfekt\SaasTerve\Models;

use Database\Factories\ObjectFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Netzperfekt\SaasBase\Models\Team;
use Netzperfekt\SaasBase\Traits\HasDefaultScopes;
use Netzperfekt\SaasBase\Traits\HasGlobalModelObserver;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Netzperfekt\SaasDeadman\Models\Infofolder;
use Netzperfekt\SaasTerve\Enums\ObjectType;

class TerveObject extends Model
{
    use HasFactory;
    use SoftDeletes;
    use HasGlobalModelObserver;
    use HasDefaultScopes;

    protected $table = 'terve_objects';

    protected $fillable = [
        'id', 'deleted_at', 'created_at', 'updated_at', 'team_id',
        'type',
        'title',
        'slug',
        'street',
        'zip',
        'city',
        'country',
        'email',
        'phone',
        'homepage',
        'image',
        'is_public'
    ];

    protected $casts = [
        'type' => ObjectType::class
    ];

    public function team(): BelongsTo
    {
        return $this->belongsTo(Team::class);
    }

    public function infofolder(): HasMany
    {
        return $this->hasMany(Infofolder::class);
    }

    public function getLocationAttribute(): array
    {
        return [
            'lat' => (float)$this->lat,
            'lng' => (float)$this->lon,
        ];
    }

    public function setLocationAttribute(?array $location): void
    {
        if (is_array($location))
        {
            $this->attributes['lat'] = $location['lat'];
            $this->attributes['lon'] = $location['lng'];
            unset($this->attributes['location']);
        }
    }

    public static function getLatLngAttributes(): array
    {
        return [
            'lat' => 'lat',
            'lng' => 'lon',
        ];
    }

    public static function getComputedLocation(): string
    {
        return 'location';
    }

    protected static function newFactory(): Factory
    {
        return ObjectFactory::new();
    }
}
