<?php

namespace Netzperfekt\SaasTerve;

use Filament\Contracts\Plugin;
use Filament\Panel;
use Netzperfekt\SaasTerve\Filament\Resources\ObjectResource\ObjectResource;

class SaasTerve implements Plugin
{
    public final const PACKAGE_NAME = 'saas-terve';

    protected bool $isEnabled = false;
    protected bool $forTenants = false;
    protected string $forTenantsPackage = '';

    public static function make(): SaasTerve
    {
        return new SaasTerve();
    }

    public function getId(): string
    {
        return self::PACKAGE_NAME;
    }

    public function register(Panel $panel): void
    {
        if($this->getIsEnabled())
        {
            $activeResources = [];

            if($this->getForTenants())
            {
                $activeResources = [
                    ObjectResource::class,
                ];
            }
            else
            {
                $activeResources = [
                    ObjectResource::class,
                ];
            }

            $panel->resources($activeResources);
        }
    }

    public function boot(Panel $panel): void
    {
        //
    }

    public function getIsEnabled(): bool
    {
        return $this->isEnabled;
    }

    public function isEnabled(bool $value): static
    {
        $this->isEnabled = $value;

        return $this;
    }

    public function getForTenants(): bool
    {
        return $this->forTenants;
    }

    public function getForTenantsPackage(): string
    {
        return $this->forTenantsPackage;
    }

    public function enableForTenantsInPackage(string $packageName): static
    {
        $this->forTenants = true;
        $this->forTenantsPackage = $packageName;

        return $this;
    }

    public static function get(): static
    {
        return filament(app(static::class)->getId());
    }
}
