<?php

namespace Netzperfekt\SaasTerve;

use Filament\Support\Assets\Css;
use Filament\Support\Assets\Js;
use Filament\Support\Facades\FilamentAsset;
use Spatie\LaravelPackageTools\Commands\InstallCommand;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class SaasTerveServiceProvider extends PackageServiceProvider
{
    public function packageRegistered(): void
    {
        $this->app->register(EventServiceProvider::class);
    }

    public function packageBooted(): void
    {
        $this->addAssets();
    }

    public function configurePackage(Package $package): void
    {
        $package
            ->name(SaasTerve::PACKAGE_NAME)
            ->hasRoute('web')
            ->hasViews()
            ->hasConfigFile()
            ->hasTranslations()

            ->hasMigrations([
                'create_objects_table',
                'create_infofolder_table',
                'create_poi_table',
            ])
            
            ->hasInstallCommand(function(InstallCommand $command)
            {
                $command
                    ->publishAssets()
                    ->publishMigrations()
                    ->publishConfigFile()
                    ->askToRunMigrations();
            });
    }

    private function addAssets()
    {
        FilamentAsset::register([
            Js::make('saas-terve-js', __DIR__ . '/../resources/dist/saas-terve.js'),
            Css::make('saas-terve-css', __DIR__ . '/../resources/dist/saas-terve.css'),
        ], 'netzperfekt/saas-terve');
    }
}
