<?php

namespace Netzperfekt\SaasTerve\Tests;

use Filament\FilamentServiceProvider;
use Filament\Forms\FormsServiceProvider;
use Filament\Support\SupportServiceProvider;
use Netzperfekt\SaasBase\Models\Team;
use Orchestra\Testbench\Attributes\WithMigration;
use Livewire\LivewireServiceProvider;
use Netzperfekt\SaasBase\SaasBaseServiceProvider;
use Orchestra\Testbench\TestCase as Orchestra;
use Illuminate\Database\Eloquent\Factories\Factory;
use Spatie\Activitylog\ActivitylogServiceProvider;
use Spatie\Translatable\TranslatableServiceProvider;

#[WithMigration('laravel', 'cache', 'job')]
class TestCase extends Orchestra
{
    // thx to https://dcblog.dev/my-process-for-writing-laravel-packages#tests
    protected function getPackageProviders($app)
    {
        return [
            LivewireServiceProvider::class,
            FilamentServiceProvider::class,
            FormsServiceProvider::class,
            SupportServiceProvider::class,
            TranslatableServiceProvider::class,
            ActivitylogServiceProvider::class,
            SaasBaseServiceProvider::class,
        ];
    }

    protected function getEnvironmentSetUp($app)
    {
        $app['config']->set('providers.users.model', \Netzperfekt\SaasBase\Models\User::class);

        $app['config']->set('database.default', 'testing');
        $app['config']->set('database.connections.mysql', [
            'driver' => 'sqlite',
            'host' => '127.0.0.1',
            'database' => ':memory:',
            'prefix' => '',
        ]);

        $app['config']->set('activitylog.default_auth_driver', null);
        $app['config']->set('activitylog.default_log_name', 'default');

        $app['config']->set('mail.default', 'log');
        $app['config']->set('queue.default', 'sync');
    }

    protected function setupDatabase()
    {
        (include __DIR__ . '/../vendor/netzperfekt/saas-base/database/migrations/create_user_types_table.php.stub')->up();
        (include __DIR__ . '/../vendor/netzperfekt/saas-base/database/migrations/create_users_table.php.stub')->up();
        (include __DIR__ . '/../vendor/netzperfekt/saas-base/database/migrations/create_teams_table.php.stub')->up();
        (include __DIR__ . '/../vendor/netzperfekt/saas-base/database/migrations/create_team_user_table.php.stub')->up();
        (include __DIR__ . '/../vendor/netzperfekt/saas-base/database/migrations/create_password_reset_tokens_table.php.stub')->up();
        (include __DIR__ . '/../vendor/netzperfekt/saas-base/database/migrations/create_activity_log_table.php.stub')->up();
        (include __DIR__ . '/../vendor/netzperfekt/saas-base/database/migrations/create_failed_jobs_table.php.stub')->up();
        (include __DIR__ . '/../vendor/netzperfekt/saas-base/database/migrations/create_settings_table.php.stub')->up();
        (include __DIR__ . '/../vendor/netzperfekt/saas-base/database/migrations/create_media_table.php.stub')->up();
        (include __DIR__ . '/../vendor/netzperfekt/saas-base/database/migrations/create_filament_media_library_table.php.stub')->up();
        (include __DIR__ . '/../vendor/netzperfekt/saas-base/database/migrations/create_filament_media_library_folders_table.php.stub')->up();

        (include __DIR__ . '/../database/migrations/create_objects_table.php.stub')->up();
        (include __DIR__ . '/../database/migrations/create_poi_table.php.stub')->up();
        (include __DIR__ . '/../database/migrations/create_infofolder_table.php.stub')->up();
    }

    protected function setUp(): void
    {
        parent::setUp();

        Factory::guessFactoryNamesUsing(function (string $modelName)
        {
            return 'Database\\Factories\\' . class_basename($modelName) . 'Factory';
        });

        $this->setupDatabase();

        $team = Team::factory()->create();
        $user = \Netzperfekt\SaasBase\Models\User::factory()->hasAttached($team)->create();
        $user->setCurrentTeamId($team->id);
        $this->actingAs($user);

        // dd(DB::select('PRAGMA table_list'));
    }
}
